
# Code for Pessimistic Data Integration for Policy Evaluation
This repository contains the official code for our NeurIPS 2025 submission on estimating the Average Treatment Effect (ATE) under distributional shift. We propose a pessimistic data integration strategy that combines experimental and historical datasets using principled weighting mechanisms.

## Project Structure

```
.
├── main.py           # Entry point for running simulations
├── utils.py          # Core functions for data generation, ATE estimators, and models
├── output/           # Directory where simulation results (CSV) are saved
└── README.md         # This documentation file
```

##  Requirements

This project requires Python ≥ 3.8. Required packages:

```bash
pip install numpy pandas matplotlib joblib torch scikit-learn statsmodels patsy
```

##  How to Run

Launch a simulation via command line as follows:

```bash
python main.py \
  --mu_diff 1.0 \
  --df 6 \
  --simu_times 100 \
  --heavy_tail_e True \
  --heavy_tail_h False \
  --multi 1 \
  --ATEB 1.0 \
  --typeR 2 \
  --seed 42
```

This will generate a result file at:

```
output/b_1.0/typeR_2/df_6/heavy_tail_eTrue_heavy_tail_hFalse/mu_diff_1.000000.csv
```
##  Parameters

| Parameter           | Type    | Required | Description |
|---------------------|---------|----------|-------------|
| `--mu_diff`         | float   | ✅        | Difference in reward between experimental and historical data |
| `--df`              | float   | ✅        | Degrees of freedom for t-distribution (if heavy-tailed) |
| `--simu_times`      | int     | No       | Number of simulation repetitions (default: 100) |
| `--heavy_tail_e`    | bool    | No       | Use heavy-tailed noise in experimental data |
| `--heavy_tail_h`    | bool    | No       | Use heavy-tailed noise in historical data |
| `--multi`           | int     | No       | Multiplier for historical sample size |
| `--ATEB`            | float   | No       | Experimental treatment effect baseline |
| `--typeR`           | int     | No       | Reward function type (1 to 5) |
| `--seed`            | int     | No       | Random seed (default: 2016) |
##  Output Format
##  Reward Function Types

| Type | Description |
|------|-------------|
| 1    | Piecewise linear with state interaction shift |
| 2    | Linear with additive shift |
| 3    | Cosine-shaped reward function shift |
| 4    | Quadratic reward shift |
| 5    | Absolute value shift |




